cwlVersion: v1.0
class: CommandLineTool
label: Extract Down Regulating CRISPR KOs
doc: Identify RNA-seq-like LINCS L1000 CRISPR KO Signatures which reverse the
  expression of the gene.
baseCommand:
  - /app/cli/pwb.sh
  - LINCSL1000ReverseSearchExtract[Gene, Down]
requirements:
  - class: DockerRequirement
    dockerImageId: maayanlab/playbook-partnership:0.73.1
inputs:
  inputs.search:
    label: LINCS L1000 Reverse Search Dashboard
    doc: A dashboard for performing L1000 Reverse Search queries for a given gene
    type: File
    inputBinding:
      prefix: --inputs.search=
      separate: false
  outputFilename:
    type: string
    default: output.json
    inputBinding:
      prefix: --output=
      separate: false
outputs:
  output:
    label: Scored Genes
    doc: ZScores of Genes
    type: File
    outputBinding:
      glob: $(inputs.outputFilename)
